// usl_vm.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include <stdio.h>
#include "..\VM\scriptHeaders.h"
#include "..\VM\opcodes.h"
#include "..\VM\FunctionInstance.h"
#include "..\VM\list.h"
#include "..\VM\interfaces.h"
#include "..\VM\manager.h"
#include "..\VM\log.h"
#include "..\VM\asmutils.h"

char*	stringConcat(char* str1,...)
{
	int			buffer_size = 0;
	char*		ptr = str1;
	char*		buffer = NULL;
	int			offset = 0;
	va_list		curr_argument;

	va_start(curr_argument,str1);

	while (ptr != NULL)
	{
		buffer_size += (int)strlen(ptr);
		ptr = va_arg(curr_argument,char*);
	}

	va_end(curr_argument);

	//mame spoctenou delku
	
	buffer = new char[buffer_size + 1];

	va_start(curr_argument,str1);
	
	ptr = str1;

	while (ptr != NULL)
	{
		strcpy(buffer + offset,ptr);
		offset += (int)strlen(ptr);
		ptr = va_arg(curr_argument,char*);
	}

	va_end(curr_argument);

	*(buffer + offset) = 0;

	return buffer;
}


int _tmain(int argc, _TCHAR* argv[])
{
	HRESULT			hRet = 0;
	IScript*		theScript = NULL;

	printf("Universal Script Virtual Machine v 0.5\n");

	if (argc < 2)
	{
		printf("Invalid arguments! Use like: usl_vm.exe script_name.usb\n");
		exit(1);
	}

	if (FAILED(CreateVMObject(IID_IScript,(void**)&theScript)))
	{
		printf("Failed to create Virtual Machine interface! Terminating...\n");
		exit(1);
	}

	char* log_file = stringConcat(argv[1],"_trace.html",NULL);
	OpenLog(log_file);
	Log("<html><body>");

	hRet = theScript->LoadScript(argv[1]);
	if (hRet == S_OK)
		printf("Script loaded!\n");
	else
	{
		printf("Failed to load script. See debug file for details.\n");
		exit(1);
	}

	printf("Launching script...\n");
    theScript->HandleScripts(0,NULL);
	printf("Done\n");
    
	theScript->Release();
	theScript = NULL;

	Log("</html>");
	CloseLog();

	return 0;
}

